<?php

//include 'services/session.php';
session_start();
$companyId = isset($_SESSION['company_id']) ? $_SESSION['company_id'] : null;

// Retrieve invoice_id from the URL
$invoice_id = isset($_GET['invoice_id']) ? $_GET['invoice_id'] : null;

// Now you can use $invoice_id in your code
?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Trial Balance";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Trial Balance";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                  <!-- Start Content-->
                  <div class="container-fluid">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                 
                                    <div class="panel-body">
                                        <div class="clearfix">
                                            <div class="float-start">
                                                <h3>Faida Accounting System</h3>
                                            </div>
                                            <div class="float-end">
                                                <h4>Trial Balance Statement <br>
                                                    <strong><?php echo $invoice_id; ?></strong>
                                                </h4>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
    
                                                <div class="float-start mt-3">
                                                    <address>
                                                        <strong>Twitter, Inc.</strong><br>
                                                        795 Folsom Ave, Suite 600<br>
                                                        San Francisco, CA 94107<br>
                                                        <abbr title="Phone">P:</abbr> (123) 456-7890
                                                    </address>
                                                </div>
                                                <div class="float-end mt-3">
                                                    <button class="btn btn-primary" id="generateTrialBalanceBtn">Generate Trial Balance</button>
                                                </div>
                                            </div><!-- end col -->
                                        </div>
                                        <!-- end row -->
                                        <div class="table-responsive">
                                            <table class="table table-bordered mt-4" id="trialBalanceTable">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Account Name</th>
                                                        <th>Total Debits</th>
                                                        <th>Total Credits</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!-- Trial balance data will be populated here -->
                                                </tbody>
                                            </table>
                                        </div>


                                        <hr>
                                        <div class="d-print-none">
                                            <div class="float-end">
                                                <a href="javascript:window.print()" class="btn btn-dark waves-effect waves-light"><i class="fa fa-print"></i></a>
                                            </div>
                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          
                        </div>

                    </div>
                    <!-- end row -->        
                    
                </div> <!-- container-fluid -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script>
            $(document).ready(function () {
                // Add an event listener to the button
                $('#generateTrialBalanceBtn').on('click', function () {
                    generateTrialBalance();
                });
            });
            
            function generateTrialBalance() {
                $.ajax({
                    type: 'GET',
                    url: 'inc_trial_balance.php',
                    success: function(response) {
                        updateTrialBalanceTable(response);
                    },
                    error: function(error) {
                        console.error('Error fetching trial balance data:', error);
                    }
                });
            }
            
            function updateTrialBalanceTable(data) {
                var trialBalanceTableBody = $('#trialBalanceTable tbody');
                trialBalanceTableBody.empty();
            
                // Assuming data is an array of objects [{account_name, total_debit, total_credit}, ...]
                $.each(data, function(index, account) {
                    var row = '<tr>' +
                              '<td>' + (index + 1) + '</td>' +
                              '<td>' + account.account_name + '</td>' +
                              '<td>' + account.total_debit + '</td>' +
                              '<td>' + account.total_credit + '</td>' +
                              '</tr>';
                    trialBalanceTableBody.append(row);
                });
            }

        </script>

    </body>
</html>